<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Loan extends Model 
{

    protected $table = 'loans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Transactions()
    {
        return $this->hasMany('Transaction');
    }

    public function Customer()
    {
        return $this->belongsTo('Customer');
    }

    public function LoanType()
    {
        return $this->belongsTo('LoanType');
    }

}